/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    DM814x_i2c.h
 *
 * \brief   Defines the module register defines for I2C
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814x I2C controller.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created.
 */

#ifndef _DM814x_aic3106_H_
#define _DM814x_aic3106_H_

#ifdef __cplusplus
 extern "C" {
#endif


/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_types.h"

/**
@addtogroup DM814x AIC3106 Audio Codec
@{
*/

/*
 *====================
 * Defines
 *====================
*/
#define AIC3106_I2C_ADDR          0x18    // I2C address
/**< I2C Slave address of the AIC3106 Audio Codec chip */

#define AIC3106_I2C_BUS_NUM		0
/**< Bus Number where AIC3106 is connected on the EVM */

#define AIC3106_REG_ADDR_MASK	0x007F;
/**< Mask for AIC316 internal register offsets */

#define 	DM814X_EVM_AIC3106_MCASP	0x48050000u
/**< Base address of the McASP being used for AIC3106 on Base Board */

#define AIC3106_PAGESELECT        0
/**< AIC3106 Page Select */

#define AIC3106_RESET             1
/**< AIC3106 reset */
/*
 *====================
 * Function declarations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to set the register value in the AIC3106 Codec
 *
 * This routine initializes the I2C instance 0. We are not configuring the 
 * interrupts here as the code is intended to carry out all I/O operations
 * in polled mode.
 *
 * \param u8RegNum		[IN]	Bus Instance number
 * \param u8RegVal		[IN]	Value to be written
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
extern STATUS aic3106RegSet
(
	UINT8	u8RegNum,
	UINT8  	u8RegVal
);

/** **************************************************************************
 * \n \brief Routine to configure the Headphone Out and play sine tone
 *
 * This routine initializes the AIC3106 Audio Codec on the base board and
 * plays a sine tone on the head-phone.
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_headphone_out 
(
	UINT8    u8McaspNum
);

/** **************************************************************************
 * \n \brief Routine to configure the Headphone Out and play sine tone
 *
 * This routine initializes the AIC3106 Audio Codec on the base board and
 * plays a sine tone on the head-phone.
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_lineout_out 
(
	UINT8    u8McaspNum
);

/** **************************************************************************
 * \n \brief Routine to configure AIC3106 to loop Line-In to Line-Out
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to take
 * input from the Line-In and play it back to Line-Out.
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_LineInLineOut_Loop 
(
	UINT8    u8McaspNum
);

/** **************************************************************************
 * \n \brief Routine to configure AIC3106 to loop Mic to head-phone
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to take
 * input from the microphone and play it back on the headphones.
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_MicHeadphone_Loop
(
	UINT8    u8McaspNum
);

/** **************************************************************************
 * \n \brief Routine to test the AIC3106 Audio codec on Base board
 *
 * This routine initializes the AIC3106 Audio Codec on the base board to test
 * various interfaces including the following
 *	(a) Playback on Head-phohne
 *  (b) Playback on Line-Out
 *  (c) Loopback the input on Microphone to head-set.
 *  (d) Loopback the input on Line-In to Line-Out
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106_tests
(
	UINT8    u8McaspNum
);


/* @} */   /* End of AIC3106 Audio Codec */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif /* _DM814x_aic3106_H_ */
